@props([
'destination' => [],
'col' => 'col-lg-4 col-md-6',
'animation' => 'fadeInUp',
])
<div class="{{$col}}">
    <div class="popular-single wow {{ $animation }}" data-wow-delay="100ms">
        <div class="popular-single-image">
            <img src="{{ loadFile($destination->thumbnail) }}"
                alt="{{$destination->name}}">
        </div>
        <div class="popular-single-content">
            <div class="icon">
                <a href="javascript:void(0)" class="item heart-icon" onclick="toggleHeart(this)" data-id="19"
                    data-type="destination" data-toggle="tooltip" title=" Please log in to add to the favorite list. ">
                    <i class="fa-regular fa-heart"></i>
                </a>
            </div>
            <div class="popular-single-content-inner">
                <div class="popular-single-title">
                    <a href="{{route('destination.show', $destination->slug)}}">{{$destination->name}}</a>

                    <p>{{ word_limit($destination->description, 10) }}</p>
                </div>
                <div class="popular-single-btn">
                    <a href="{{route('destination.show', $destination->slug)}}" class="btn-2">Discover
                        Now<span></span></a>
                </div>
            </div>
        </div>
    </div>
</div>
@once
@push('script')
<script>
    function toggleHeart(element) {
        let heartIcon = $(element).find('i.fa-heart');
        let destinationId = $(element).data('id');

        if (heartIcon.hasClass('fa-solid')) {
            removeFavorite(destinationId);
            heartIcon.removeClass('fa-solid').addClass('fa-regular');
            heartIcon.css('color', '');
        } else {
            addFavorite(destinationId);
            heartIcon.removeClass('fa-regular').addClass('fa-solid');
            heartIcon.css('color', 'red');
        }
    }

    function addFavorite(destinationId) {
        $.ajax({
            url: '/reaction',
            type: 'GET',
            data: {
                destination_id: destinationId,
                reaction: 1
            },
            success: function(response) {
                Notiflix.Notify.success(response.message);
            },
            error: function(xhr, status, error) {
                console.error(error);
            }
        });
    }

    function removeFavorite(destinationId) {
        $.ajax({
            url: '/reaction',
            type: 'GET',
            data: {
                destination_id: destinationId,
                reaction: 0
            },
            success: function(response) {
                Notiflix.Notify.success(response.message);
            },
            error: function(xhr, status, error) {
                console.error(error);
            }
        });
    }
</script>
@endpush
@endonce
